
import java.awt.*;
import java.awt.image.*;
import java.applet.*;

public class MySpace extends Applet{

	int xp, yp;
	MyPoint[] points;
	int numPoints = 30;

	Image offImage;
	Graphics offGraphics;

	Image picture;
	BufferedImage bpicture;
	Graphics bgraphics;

/**
 * A simple program that handles 3D projections.
 *
 * @author DEVELOPER
 * @since 1.0 (1/15/01)
 ************************************/
	public void init(){



/*
      picture = getImage(getDocumentBase(),"screenSnap.gif");

      try{
		  MediaTracker tracker = new MediaTracker(this);
		  tracker.addImage(picture, 0);
		  tracker.waitForID(0);
	  }
	  catch(Exception e)  {  }

      int height = picture.getHeight(this);
      int width = picture.getWidth(this);


      bpicture = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
      bgraphics = bpicture.createGraphics();
      bgraphics.drawImage(picture, 0, 0, this);
      ColorModel cm = ColorModel.getRGBdefault();

      points = new MyPoint[width*height];

      for(int i=0; i<width; i++)
        for(int j=0; j<height; j++){
          int pixel = bpicture.getRGB(i, j);
          points[i*height+j] = new MyPoint(i  , j  , cm.getBlue(pixel)  );
          points[i*height+j].setColor(new Color(cm.getRed(pixel), cm.getGreen(pixel), cm.getBlue(pixel)));
      }


*/

      points = new MyPoint[numPoints*numPoints];

      for(int j=0; j<numPoints; j++)
         for(int i=0; i<numPoints; i++){
			int c1 = (int)(255. * Math.sin(Math.PI/180. * i * 5));
			int c2 = (int)(255. * Math.cos(Math.PI/180. * j * 5));
			int c3 = c2;

            int range = 255;

			c1 = range-Math.abs(c1) % range;
			c2 = range-Math.abs(c2) % range;
			c3 = range-Math.abs(c3) % range;

			points[i*numPoints+j] = new MyPoint((double) i*2, (double) j*2, (double) ((c1+c2+c3)/9));
			points[i*numPoints+j].setColor(new Color(c1, c2, c3));

		}


/*
         points[0] = new MyPoint(0.  , 0.  , 0.  );
         points[1] = new MyPoint(100., 0.  , 0.  );
         points[2] = new MyPoint(100., 100., 0.  );
         points[3] = new MyPoint(0.  , 100., 0.  );
         points[4] = new MyPoint(0.  , 0.  , 100.);
         points[5] = new MyPoint(100., 0.  , 100.);
         points[6] = new MyPoint(100., 100., 100.);
         points[7] = new MyPoint(0.  , 100., 100.);


*/
         offImage = createImage(800, 600);
         offGraphics = offImage.getGraphics();


         for(int i=0; i<points.length; i++)
             points[i].move(-15., -15., -15.);

         repaint();
	}


	//*******************
	public void paint(Graphics g){

        offGraphics.setColor(Color.white);
        offGraphics.fillRect(0, 0, 800, 600);


        for(int i=0; i<points.length-1-numPoints; i++){
			MyPoint p1 = new MyPoint(0.,0.,0.);
			p1 = points[i].setAxonometric();
			int x1 = (int)(4*p1.x) + 300;
			int y1 = (int)(4*p1.y) + 300;
			MyPoint pnext = new MyPoint(0.,0.,0.);
			pnext = points[i+1].setAxonometric();
			int xnext = (int)(4*pnext.x) + 300;
			int ynext = (int)(4*pnext.y) + 300;
            MyPoint pleft = new MyPoint(0.,0.,0.);
			pleft = points[i+numPoints].setAxonometric();
			int xleft = (int)(4*pleft.x) + 300;
			int yleft = (int)(4*pleft.y) + 300;

			//offGraphics.drawRect(x1, y1, 2, 2);
			offGraphics.setColor(points[i].color);
			if((i+1)%numPoints != 0)offGraphics.drawLine(x1, y1, xnext, ynext);
			if((i+1)%numPoints != 0)offGraphics.drawLine(x1, y1, xleft, yleft);
		}

		//offGraphics.drawImage(picture, 0, 0, this);

		g.drawImage(offImage, 0, 0, this);

	}


	//*********************
		public boolean mouseDown(Event e, int x, int y){

			xp = x;
			yp = y;

			return true;
		}



	//*******************
	public boolean mouseDrag(Event e, int x, int y){

		int xoff = x - xp;
		int yoff = y - yp;

		for(int i=0; i<points.length; i++){
			points[i].rotatey(xoff * Math.PI/180.);
			points[i].rotatex(yoff * Math.PI/180.);
		}

		repaint();

		xp = x;
		yp = y;

		return true;
	}



}