
import java.applet.*;
import java.awt.*;
import java.awt.image.*;


public class MyCosineCloud  extends Applet{

	 MyPoint[] points;
	 int xf, yf;
	 Graphics offGraphics;
	 Image offImage;
	 int width = 100, height = 100;

     //**********************
	 public void init(){

         //*** initialize double buffering
         offImage = createImage(800, 600);
		 offGraphics = offImage.getGraphics();

         //*** allocate memory for the points array
		 points = new MyPoint[width*height];

		 //*** fill the points array
		 for(int i=0; i<width; i++)
			for(int j=0; j<height; j++){

				int c1 = (int)(50. * Math.cos(Math.PI/180. * (i * 6)));
				int c2 = (int)(50. * Math.sin(Math.PI/180. * (j * 6)));
				int c3 = c1 * c2;



				c1 = 5*Math.abs(c1);  //co/sine may be negative!
				c2 = 5*Math.abs(c2);  //co/sine may be negative!
				c3 = 255-Math.abs(c3)%255;  //co/sine may be negative!
				points[i*height+j] = new MyPoint((double) i*2, (double) j*2, (double) c3);

				points[i*height+j].setColor(new Color(c1, c2, c3));

			}

		  //*** move to the center of rotation
          for(int i=0; i<points.length; i++)
              points[i].move(-100., -100.,-100.);

	 }

    /*********************/
	public void paint(Graphics g){

		offGraphics.setColor(Color.white);
		offGraphics.fillRect(0,0,800, 600);

		offGraphics.setColor(Color.black);

		for(int i=0; i<points.length; i++){
			MyPoint p = points[i].setPerspective();
			offGraphics.setColor(points[i].color);
			offGraphics.fillRect((int)p.x+width+50, (int)p.y+height, 2, 2);
		}

        // draw the buffer
        g.drawImage(offImage, 0, 0, this);


	}


//************************************************
	public boolean mouseDown(Event e, int x, int y){

		xf = x;
		yf = y;
		return true;

	}

    //************************************************
	public boolean mouseDrag(Event e, int x, int y){

        int xoff = x - xf;
        int yoff = y - yf;

		for(int i=0; i<points.length; i++){
		   points[i].rotatex(xoff*Math.PI/180);
		   points[i].rotatey(yoff*Math.PI/180);
	   }
		repaint();
		xf = x;
		yf = y;
		return true;
	}

}