import java.io.*;
import java.util.*;

public class MyFile {

    public MyFile(){
        ;
    }


/*********************************************************/
void writeDXFFile(MyPoint[] points, String filename) throws IOException
     {

       System.out.println("Writing file " + filename + "...");
       FileOutputStream file = new FileOutputStream(filename);
       DataOutputStream stream = new DataOutputStream(file);

        try {
             stream.writeBytes("999\r\n");
             stream.writeBytes("Kostas\r\n");
             stream.writeBytes("  0\r\n");
             stream.writeBytes("SECTION\r\n");
             stream.writeBytes("  2\r\n");
             stream.writeBytes("ENTITIES\r\n");
             stream.writeBytes("  0\r\n");

              // for shapes
             for(int i=0; i<points.length; i++){
                 stream.writeBytes("POLYLINE\r\n");
                 stream.writeBytes("  8\r\n");      // layer
                 stream.writeBytes("layer_1\r\n");
                 stream.writeBytes(" 66\r\n");
                 stream.writeBytes("    1\r\n");
                 stream.writeBytes(" 70\r\n");
                 stream.writeBytes("    9\r\n");
                 stream.writeBytes(" 62\r\n");      // Color
                 stream.writeBytes("   183\r\n");
                 stream.writeBytes("  0\r\n");
				 stream.writeBytes("VERTEX\r\n");
				 stream.writeBytes("10\r\n");   // x
				 stream.writeBytes(Double.toString(points[i].x) +"\r\n");
				 stream.writeBytes(" 20\r\n");  // y
				 stream.writeBytes(Double.toString(points[i].y)+"\r\n");
				 stream.writeBytes(" 30\r\n");  // z
				 stream.writeBytes(Double.toString(points[i].z)+"\r\n");
				 stream.writeBytes(" 70\r\n");
				 stream.writeBytes("   32\r\n");
				 stream.writeBytes("  0\r\n");
                 stream.writeBytes("SEQEND\r\n");
                 stream.writeBytes("  0\r\n");
             }

           stream.writeBytes("ENDSEC\r\n");
           stream.writeBytes("  0\r\n");
           stream.writeBytes("EOF\r\n");

           //*** Finish
           stream.flush();
           stream.close();

           }
        catch(IOException e) {
            System.err.println("Problems writing file!!" );
           }

     }


/**********************************************************/
 public MyPoint[] readDXFFile(String fileIn) throws IOException
     {

     Vector vpoints = new Vector();

     System.out.println("Reading DXF file " + fileIn + "...");
     FileInputStream is = new FileInputStream(fileIn);
     DataInputStream file = new DataInputStream(is);

	 StreamTokenizer st = new StreamTokenizer(is);
	 st.eolIsSignificant(true);
     st.wordChars(' ','_');

    boolean exit = false;  //flag to exit

    double x = 0.;
    double y = 0.;
    double z = 0.;

	while (true) {
	    if(exit) break;
        st.nextToken();
	    switch (st.ttype) {
		case StreamTokenizer.TT_EOF:
		 exit = true;
		break;
		case StreamTokenizer.TT_NUMBER:
		    if (st.nval == 10){
			if(st.nextToken() == StreamTokenizer.TT_EOL)
			if (st.nextToken() == StreamTokenizer.TT_NUMBER)
			      x = st.nval;
		    if(st.nextToken() == StreamTokenizer.TT_EOL)
			if (st.nextToken() == StreamTokenizer.TT_NUMBER)
			if(st.nextToken() == StreamTokenizer.TT_EOL)
			if (st.nextToken() == StreamTokenizer.TT_NUMBER)
			      y = st.nval;
		    if(st.nextToken() == StreamTokenizer.TT_EOL)
			if (st.nextToken() == StreamTokenizer.TT_NUMBER)
			if(st.nextToken() == StreamTokenizer.TT_EOL)
			if (st.nextToken() == StreamTokenizer.TT_NUMBER)
			      z = st.nval;

			vpoints.addElement(new MyPoint(x, y, z));
		}
        break;
        default:
		break;
	    }  /* switch */
	}  /* while */


    System.out.println("Finished ");
    int numPoints = vpoints.size();
    MyPoint[] points = new MyPoint[numPoints];
    for(int i=0; i<numPoints; i++)
         points[i] = (MyPoint)vpoints.elementAt(i);

	file.close();
    return points;
    }



}