
import java.applet.*;
import java.awt.*;
import java.awt.image.*;
import java.io.*;


public class MyDXFCloud  extends Applet{

	 MyPoint[] points;
	 int xf, yf;
	 Graphics offGraphics;
	 Image offImage;
	 int width = 100, height = 100;

     //**********************
	 public void init(){

         //*** initialize double buffering
         offImage = createImage(800, 600);
		 offGraphics = offImage.getGraphics();

         //*** read a file to fill the points array
         MyFile file = new MyFile();

         try{
		     points = file.readDXFFile("struct.dxf");
		 }
		 catch(IOException ioe){  }

		  //*** move to the center of rotation
          for(int i=0; i<points.length; i++)
              points[i].move(-50., -50.,-50.);

	 }

    /*********************/
	public void paint(Graphics g){

		offGraphics.setColor(Color.white);
		offGraphics.fillRect(0,0,800, 600);

		offGraphics.setColor(Color.black);

		for(int i=0; i<points.length; i++){
			MyPoint p = points[i].setPerspective();
			offGraphics.setColor(points[i].color);
			offGraphics.fillRect((int)p.x+width+50, (int)p.y+height, 2, 2);
		}

        // draw the buffer
        g.drawImage(offImage, 0, 0, this);


	}


//************************************************
	public boolean mouseDown(Event e, int x, int y){

		xf = x;
		yf = y;
		return true;

	}

    //************************************************
	public boolean mouseDrag(Event e, int x, int y){

        int xoff = x - xf;
        int yoff = y - yf;

		for(int i=0; i<points.length; i++){
		   points[i].rotatex(xoff*Math.PI/180);
		   points[i].rotatey(yoff*Math.PI/180);
	   }
		repaint();
		xf = x;
		yf = y;
		return true;
	}

}