
import java.awt.*;
import java.awt.image.*;
import java.applet.*;

public class MySpace extends Applet{

	int xp, yp;
	MyPoint[] points;
	int numPoints = 180;

	Image offImage;
	Graphics offGraphics;

/**
 * A simple program that handles 3D projections.
 *
 * @author DEVELOPER
 * @since 1.0 (1/15/01)
 ************************************/
	public void init(){

         points = new MyPoint[numPoints*numPoints];

      for(int j=0; j<numPoints; j++)
         for(int i=0; i<numPoints; i++){
            double xoffset = 50. * Math.sin(Math.PI/180.*i);
            double yoffset = 50. * Math.cos(Math.PI/180.*j);
            points[i*numPoints+j] = new MyPoint(i  , j  , xoffset * yoffset  );
            points[i*numPoints+j].setColor(new Color(0, (int)(5*xoffset), (int)(Math.abs(5*yoffset))));
		}


/*
         points[0] = new MyPoint(0.  , 0.  , 0.  );
         points[1] = new MyPoint(100., 0.  , 0.  );
         points[2] = new MyPoint(100., 100., 0.  );
         points[3] = new MyPoint(0.  , 100., 0.  );
         points[4] = new MyPoint(0.  , 0.  , 100.);
         points[5] = new MyPoint(100., 0.  , 100.);
         points[6] = new MyPoint(100., 100., 100.);
         points[7] = new MyPoint(0.  , 100., 100.);


*/
         offImage = createImage(800, 600);
         offGraphics = offImage.getGraphics();


         for(int i=0; i<points.length; i++)
             points[i].move(-50., -50., -50.);

         repaint();
	}


	//*******************
	public void paint(Graphics g){

        offGraphics.setColor(Color.white);
        offGraphics.fillRect(0, 0, 800, 600);


        for(int i=0; i<points.length; i++){
			MyPoint p1 = new MyPoint(0.,0.,0.);
			p1 = points[i].setPerspective();
			int x1 = (int)(2*p1.x) + 300;
			int y1 = (int)(2*p1.y) + 300;
			offGraphics.setColor(points[i].color);
			offGraphics.fillRect(x1, y1, 2, 2);
			//g.drawString(".", xpos, ypos);
		}

		g.drawImage(offImage, 0, 0, this);

	}


	//*********************
		public boolean mouseDown(Event e, int x, int y){

			xp = x;
			yp = y;

			return true;
		}



	//*******************
	public boolean mouseDrag(Event e, int x, int y){

		int xoff = x - xp;
		int yoff = y - yp;

		for(int i=0; i<points.length; i++){
			points[i].rotatey(xoff * Math.PI/180.);
			points[i].rotatex(yoff * Math.PI/180.);
		}

		repaint();

		xp = x;
		yp = y;

		return true;
	}



}