import java.io.*;
import java.util.*;

public class MyFile {


/*********************************************************/
void writeDXF(MyGroup group, String filename) throws IOException
     {

       System.out.println("Writing file " + filename + "...");
       FileOutputStream file = new FileOutputStream(filename);
       DataOutputStream stream = new DataOutputStream(file);

        try {
             stream.writeBytes("999\r\n");
             stream.writeBytes("Kostas\r\n");  // put some identification here
             stream.writeBytes("  0\r\n");
             stream.writeBytes("SECTION\r\n");
             stream.writeBytes("  2\r\n");
             stream.writeBytes("ENTITIES\r\n");
             stream.writeBytes("  0\r\n");

             for(int k=0; k<group.numSolids; k++){

              //faces
             for(int j=0; j<group.solids[k].numFaces; j++)  {
                 stream.writeBytes("POLYLINE\r\n");
                 stream.writeBytes("  8\r\n");
                 stream.writeBytes("layer_1\r\n");
                 stream.writeBytes(" 66\r\n");
                 stream.writeBytes("    1\r\n");
                 stream.writeBytes(" 70\r\n");
                 stream.writeBytes("    9\r\n");
                 stream.writeBytes(" 62\r\n");
                 stream.writeBytes("   183\r\n");
                 stream.writeBytes("  0\r\n");

                 //points
                 for(int i=0; i<group.solids[k].faces[j].numPoints; i++)  {
                    stream.writeBytes("VERTEX\r\n");
                    stream.writeBytes("  8\r\n");
                    stream.writeBytes("layer_1\r\n");
                    stream.writeBytes(" 62\r\n");
                    stream.writeBytes("183\r\n");
                    stream.writeBytes("10\r\n");
                    stream.writeBytes(Double.toString(group.solids[k].faces[j].points[i].x)+"\r\n");
                    stream.writeBytes(" 20\r\n");
                    stream.writeBytes(Double.toString(group.solids[k].faces[j].points[i].y)+"\r\n");
                    stream.writeBytes(" 30\r\n");
                    stream.writeBytes(Double.toString(group.solids[k].faces[j].points[i].z)+"\r\n");
                    stream.writeBytes(" 70\r\n");
                    stream.writeBytes("   32\r\n");
                    stream.writeBytes("  0\r\n");

                  }
               stream.writeBytes("SEQEND\r\n");
               stream.writeBytes("  0\r\n");
              }

             }

           stream.writeBytes("ENDSEC\r\n");
           stream.writeBytes("  0\r\n");
           stream.writeBytes("EOF\r\n");

           //*** Finish
           stream.flush();
           stream.close();

           }
        catch(IOException e) {
            System.err.println("Problems writing file!!" );
           }

     }



//********************************
 public MyGroup readDXFFile(String fileIn) throws IOException
     {

     Vector vpoints = new Vector();
     Vector vfaces = new Vector();

     System.out.println("Reading DXF file " + fileIn + "...");
     File is = new File(fileIn);
     FileReader file = new FileReader(is);

	 StreamTokenizer st = new StreamTokenizer(file);
     st.wordChars(' ','_');
     boolean poly_flag = false;

    boolean exit = false;  //flag to exit

    double x = 0.;
    double y = 0.;
    double z = 0.;

	while (true) {
	    if(exit) break;
        st.nextToken();
	    switch (st.ttype) {
		case StreamTokenizer.TT_EOF:
		 exit = true;
		break;
		case StreamTokenizer.TT_WORD:
		    if("POLYLINE".equals(st.sval))poly_flag = true;
		    if("SEQEND".equals(st.sval)){
			   poly_flag = false;
			   int numPoints = vpoints.size();
			   MyPoint[] points = new MyPoint[numPoints];
			   for(int i=0; i<numPoints; i++)
				   points[i] = (MyPoint)vpoints.elementAt(numPoints-1-i);
		       vfaces.addElement(new MyFace(points));
		       vpoints.removeAllElements();
		   }
		break;
		case StreamTokenizer.TT_NUMBER:
		    if (poly_flag==true && st.nval == 10){
			if (st.nextToken() == StreamTokenizer.TT_NUMBER)
			      x = st.nval;
			if (st.nextToken() == StreamTokenizer.TT_NUMBER)
			if (st.nextToken() == StreamTokenizer.TT_NUMBER)
			      y = st.nval;
			if (st.nextToken() == StreamTokenizer.TT_NUMBER)
			if (st.nextToken() == StreamTokenizer.TT_NUMBER)
			      z = st.nval;

			vpoints.addElement(new MyPoint(x, y, z));
		}
        break;
        default:
		break;
	    }  /* switch */
	}  /* while */


    System.out.println("Finished ");
    int numFaces = vfaces.size();
    MyFace[] faces = new MyFace[numFaces];
    for(int i=0; i<numFaces; i++)
         faces[i] = (MyFace)vfaces.elementAt(i);

    MySolid[] solids = new MySolid[numFaces];
    for(int i=0; i<numFaces; i++){
		MyFace[] aFace = new MyFace[1];
		aFace[0] = new MyFace(faces[i].points);
       solids[i] = new MySolid(aFace);
   }

    MyGroup group = new MyGroup(solids);
    group.setScale(.3, .3, .3);
	file.close();
    return group;
    }



//********************************
 public MyGroup readVRMLFile(String fileIn) throws IOException
    {

    Vector vpoints = new Vector();
    Vector vfaces = new Vector();
    Vector vpointsindex = new Vector();

    System.out.println("Reading DXF file " + fileIn + "...");
    File is = new File(fileIn);
    FileReader file = new FileReader(is);

	StreamTokenizer st = new StreamTokenizer(file);

    boolean exit = false;  //flag to exit
    boolean coord_flag = false;
    boolean coordindex_flag = false;

    double[] coord;
    coord = new double[3];
    int knt = 0;

	while (true) {
	    if(exit) break;
        st.nextToken();
	    switch (st.ttype) {
		case StreamTokenizer.TT_EOF:
		 exit = true;
		break;
		case StreamTokenizer.TT_WORD:
		    if("coord".equals(st.sval)) {
				coord_flag=true; coordindex_flag = false;
				vpoints.removeAllElements();
				}
		    if("coordIndex".equals(st.sval)) {
				coord_flag=false;  coordindex_flag = true;
				vpointsindex.removeAllElements();
				}
		break;
		case StreamTokenizer.TT_NUMBER:
			if (coord_flag==true){
			      coord[knt] = st.nval;
			      knt++;
			      if(knt==3){
			         knt = 0;
			         vpoints.addElement(new MyPoint(coord[0]*20, coord[1]*20, coord[2]*20));
			      }
		    }

		    if (coordindex_flag==true){
					if(st.nval != -1)
					  vpointsindex.addElement(new Integer((int)st.nval));
					else{
					   int numPoints = vpointsindex.size();
					   MyPoint[] points = new MyPoint[numPoints];
					   for(int i=0; i<numPoints; i++){
						   Integer index = (Integer)vpointsindex.elementAt(i);
						   points[i] = (MyPoint)vpoints.elementAt(index.intValue());
					   }
					   vfaces.addElement(new MyFace(points));
					}
		    }
        break;
        default:
		break;
	    }  /* switch */
	}  /* while */


    System.out.println("Finished ");
    int numFaces = vfaces.size();
    MyFace[] faces = new MyFace[numFaces];
    for(int i=0; i<numFaces; i++)
         faces[i] = (MyFace)vfaces.elementAt(i);

    MySolid[] solids = new MySolid[numFaces];
    for(int i=0; i<numFaces; i++){
		MyFace[] aFace = new MyFace[1];
		aFace[0] = new MyFace(faces[i].points);
       solids[i] = new MySolid(aFace);
   }

    MyGroup group = new MyGroup(solids);
	file.close();
    return group;
    }


}