
import java.awt.*;


public class MySolid  {

	MyFace[] faces;
	int numFaces;
	Color color;

	public MySolid(MyPoint[] inPoints, double height){

        numFaces = 0;
		faces = new MyFace[inPoints.length + 2];

		//bottom
		faces[0] = new MyFace(inPoints);
		numFaces++;

		//top
		faces[numFaces] = new MyFace(inPoints);
		faces[numFaces].setMove(0., 0., height);
		numFaces++;


		MyPoint[] side;
		side = new MyPoint[4];
		for(int i=0; i<inPoints.length-1; i++){
			 side[0] = new MyPoint(faces[0].points[i].x, faces[0].points[i].y, faces[0].points[i].z );
			 side[1] = new MyPoint(faces[0].points[i+1].x,faces[0].points[i+1].y,faces[0].points[i+1].z );
			 side[2] = new MyPoint(faces[1].points[i+1].x,faces[1].points[i+1].y,faces[1].points[i+1].z  );
			 side[3] = new MyPoint(faces[1].points[i].x, faces[1].points[i].y, faces[1].points[i].z  );
		     faces[numFaces] = new MyFace(side);
		     numFaces++;
		}

         // last side face
         int last = inPoints.length-1;
		 side[0] = new MyPoint(faces[0].points[last].x, faces[0].points[last].y, faces[0].points[last].z );
		 side[1] = new MyPoint(faces[0].points[0].x,faces[0].points[0].y,faces[0].points[0].z );
		 side[2] = new MyPoint(faces[1].points[0].x,faces[1].points[0].y,faces[1].points[0].z  );
		 side[3] = new MyPoint(faces[1].points[last].x, faces[1].points[last].y, faces[1].points[last].z  );
		 faces[numFaces] = new MyFace(side);
		 numFaces++;


         // reverse the order of the bottom face
		 MyPoint[] revPoints;
		 revPoints = new MyPoint[inPoints.length];
		 for(int i=0; i<inPoints.length; i++){
		    revPoints[i] = new MyPoint(inPoints[inPoints.length-1-i].x,
		                               inPoints[inPoints.length-1-i].y,
		                               inPoints[inPoints.length-1-i].z);
		 }
		 faces[0] = new MyFace(revPoints);



	}



       //******************
       public void draw(Graphics g){

	         for(int i=0; i<numFaces; i++)
	             faces[i].draw(g);


	   }

	    //*************
	    public void setRotatex (double angle) {
	         for(int i=0; i<numFaces; i++)
	             faces[i].setRotatex(angle);
	    }

	    //*************
	    public void setRotatey (double angle) {
	         for(int i=0; i<numFaces; i++)
	             faces[i].setRotatey(angle);
	    }

	    //*************
	    public void setRotatez (double angle) {
	         for(int i=0; i<numFaces; i++)
	             faces[i].setRotatez(angle);
	     }

	    //*************
	    public void setScale(double xs, double ys, double zs){
	         for(int i=0; i<numFaces; i++)
	             faces[i].setScale(xs, ys, zs);
	    }

	    //*************
	    public void setMove(double xoff, double yoff, double zoff){
	         for(int i=0; i<numFaces; i++)
	             faces[i].setMove(xoff, yoff, zoff);
	    }

}