

public class MyVector{

    double i,j,k;


    public MyVector(double x, double y, double z){
        i = x;
        j = y;
        k = z;
    }

    public MyVector(double x, double y, double z,boolean normalized){
        double t = Math.sqrt(x*x+y*y+z*z);
        i = x/t;
        j = y/t;
        k = z/t;
    }

    public MyVector buildVector( MyPoint vert1, MyPoint vert2){
        i = vert2.x-vert1.x;
        j = vert2.y-vert1.y;
        k = vert2.z-vert1.z;
        return this;
    }

    public double dot(MyVector v1){
        return v1.i*i+v1.j*j+v1.k*k;
    }


    public void cross(MyVector v1){
		MyVector temp = new MyVector(0.,0.,0.);
        temp.i = j*v1.k - k*v1.j;
        temp.j = k*v1.i - i*v1.k;
        temp.k = i*v1.j - j*v1.i;
        i = temp.i;
        j = temp.j;
        k = temp.k;
    }

    public void norm(){
        double t = Math.sqrt(i*i+j*j+k*k);
        i = i/t;
        j = j/t;
        k = k/t;
    }

    public void print(){
        System.out.println("i:" + i);
        System.out.println("j:" + j);
        System.out.println("k:" + k);
    }
}