
import java.awt.*;


public class MyGroup  {

	MySolid[] solids;
	int numSolids;

	public MyGroup(MySolid[] inSolids){

        numSolids = inSolids.length;
        solids = new MySolid[numSolids];
        for(int i=0; i<numSolids; i++)
           solids[i] = new MySolid(inSolids[i].faces);   // pointers


	}



       //******************
       public void sort(){

		   double[] zc;
		   zc = new double[numSolids];
		   int knt;
		   double centerz;
		   // Calculate the cetroids of each solid
		   for(int i=0; i<numSolids; i++){
			   centerz = 0;
			   knt = 0;
		       for(int j=0; j<solids[i].numFaces; j++){
		           for(int k=0; k<solids[i].faces[j].numPoints; k++){
					   centerz += solids[i].faces[j].points[k].z;
					   knt++;
				   }
		        }
		     zc[i] = centerz/knt;
			}


			// Sorting the objects
			for(int i=0; i<numSolids; i++)
			    for(int j=0; j<numSolids; j++)
			        if(zc[i] > zc[j]){
			            MySolid tobj = solids[i];
			            solids[i] = solids[j];
			            solids[j] = tobj;
			            double temp = zc[i];
			            zc[i] = zc[j];
			            zc[j] = temp;
			        }


	   }

       //******************
       public void draw(Graphics g){

       sort();
	         for(int i=0; i<numSolids; i++)
	             solids[numSolids-1-i].draw(g);


	   }

	    //*************
	    public void setRotatex (double angle) {
	         for(int i=0; i<numSolids; i++)
	             solids[i].setRotatex(angle);
	    }

	    //*************
	    public void setRotatey (double angle) {
	         for(int i=0; i<numSolids; i++)
	             solids[i].setRotatey(angle);
	    }

	    //*************
	    public void setRotatez (double angle) {
	         for(int i=0; i<numSolids; i++)
	             solids[i].setRotatez(angle);
	     }

	    //*************
	    public void setScale(double xs, double ys, double zs){
	         for(int i=0; i<numSolids; i++)
	             solids[i].setScale(xs, ys, zs);
	    }

	    //*************
	    public void setMove(double xoff, double yoff, double zoff){
	         for(int i=0; i<numSolids; i++)
	             solids[i].setMove(xoff, yoff, zoff);
	    }

		//*************
		public  boolean pick(int xmouse, int ymouse){
			boolean in = false;
			for(int i=0; i<numSolids; i++)
			    if(solids[i].pick(xmouse, ymouse) == true){
			        in = true;
			        System.out.println("Found solid " + i);
			        break;
			    }
            return in;
		}
}