
import java.awt.*;


public class MyFace  {

	MyPoint[] points;
	int numPoints;
	Color color;
	Color[] shadeTable;
	MyVector temp1 = new MyVector(0.,0.,0.);
	MyVector temp2 = new MyVector(0.,0.,0.);
	int shade;
	static MyVector vlight = new MyVector(0.5, -1., 2.,true);



	public MyFace(MyPoint[] inPoints){

		numPoints = inPoints.length;
		points = new MyPoint[numPoints];
		for(int i=0; i<numPoints; i++)
		    points[i] = new MyPoint(inPoints[i].x, inPoints[i].y, inPoints[i].z);

		//color = new Color(255, 0, 0);

		setColor(new Color(255, 255, 255));
		color = shadeTable[calcShade()];
        shadeTable = null;

	}


	public MyFace(int numSides, double radius, double xc, double yc){

		numPoints = numSides;
		points = new MyPoint[numPoints];

		double angle = 2 * Math.PI / numSides;
		for(int i =0; i<numSides; i++)
		    points[i] = new MyPoint(xc + radius * Math.sin(angle*i),
		                            yc + radius * Math.cos(angle*i),
		                            0.);

		setColor(new Color(255, 255, 255));
		color = shadeTable[calcShade()];
		shadeTable = null;


		}

	//**********************
	void setColor(Color c) {
		    double r, g, b;
		    //System.out.println("rgb1 = " + c);
		    r = c.getRed(); r/=255.;
		    g = c.getGreen(); g/=255.;
		    b = c.getBlue(); b/=255.;
	        if (shadeTable == null)
	            shadeTable = new Color[256];
			for( int i = 0; i < 255; i++ )
	            shadeTable[i] = new Color((int)(r*i),(int)(g*i),(int)(b*i));
	}


	  //********* HIDDEN SURFACE REMOVAL( MARKS visible AS 0 OR 1)
	  public int calcShade(){
	        int shade;
	            temp1.buildVector( points[0], points[1] ).cross(temp2.buildVector( points[1], points[2] ));
	            temp1.norm();
	            if (temp1.k < 0) {
	                shade = 0 ;
	            } else {
	                shade = (int)( 100+(155*temp1.dot(vlight)));
	                //shade = (int)( 255*temp1.dot(vlight));
	                if (shade <= 0) shade = 0;
	            }
	      return shade;
	    }



       //******************
       public void draw(Graphics g){

		   Polygon poly = new Polygon();
		   for(int i=0; i<numPoints; i++){
		       MyPoint p = points[i].setPerspective();
		       poly.addPoint((int)p.x+200, (int)p.y+200);
		   }

          if(visible(poly)){
           g.setColor(color);
		   g.fillPolygon(poly);
		   g.setColor(Color.black);
		   g.drawPolygon(poly);
	       }


	   }


	  /********************************************
		 Determines whether a set of point in a polygon (xList, yList)
		 is clock or counter-clockwise
		 This routine is useful for telling whether a face is visible
		 *******************************************/
	   public boolean visible(Polygon poly)  {
		   float x1, y1, x2, y2, norm=0;
		   int ahead1, ahead2;

		   for (int i=0; i<poly.npoints; i++) {
			   ahead1 = i+1;
			   ahead2 = i+2;
			   if(i == (poly.npoints -2)) ahead2 = 0;
			   if(i == (poly.npoints -1)) { ahead2=1; ahead1=0; }
			   x1 = poly.xpoints[i] - poly.xpoints[ahead1];
			   y1 = poly.ypoints[i] - poly.ypoints[ahead1];
			   x2 = poly.xpoints[ahead2] - poly.xpoints[ahead1];
			   y2 = poly.ypoints[ahead2] - poly.ypoints[ahead1];
			   norm += (x1*y2 - y1*x2);
		   }
		   if(norm < 0.0) return false;
		   else  return true;

       }



       //**************
         public double zcenter(){

			 double zc = 0.;
			 for(int i=0; i<numPoints; i++)
			     zc += points[i].z;

			 return(zc/numPoints);
		 }

	    //*************
	    public void setRotatex (double angle) {
	         for(int i=0; i<numPoints; i++)
	             points[i].setRotatex(angle);
	    }

	    //*************
	    public void setRotatey (double angle) {
	         for(int i=0; i<numPoints; i++)
	             points[i].setRotatey(angle);
	    }

	    //*************
	    public void setRotatez (double angle) {
	         for(int i=0; i<numPoints; i++)
	             points[i].setRotatez(angle);
	     }

	    //*************
	    public void setScale(double xs, double ys, double zs){
	         for(int i=0; i<numPoints; i++)
	             points[i].setScale(xs, ys, zs);
	    }

	    //*************
	    public void setMove(double xoff, double yoff, double zoff){
	         for(int i=0; i<numPoints; i++)
	             points[i].setMove(xoff, yoff, zoff);
	    }


    //*************
	public boolean pick(int xmouse, int ymouse){

		   Polygon poly = new Polygon();
		   for(int i=0; i<numPoints; i++){
		       MyPoint p = points[i].setPerspective();
		       poly.addPoint((int)p.x+200, (int)p.y+200);
		   }
//System.out.println(xmouse + " " + ymouse + " " + poly.xpoints[0] + " " + poly.ypoints[0] + " " + poly.contains(xmouse, ymouse));
		return poly.contains(xmouse, ymouse);
		}



}