import java.awt.*;

//*************
class MyPoint {

   double x,y,z;
   Color color;

   //*************
   MyPoint(double i, double j, double k){
        x = i;
        y = j;
        z = k;

        color = new Color(0,0,0);
   }



    //*************
    public void setColor(Color c){

	   color = c;

    }

    //*************
    public void setRotatex (double angle) {
         //Rotates point around y-axis
          double newx =   x * Math.cos(angle) + z * Math.sin(angle);
          double newz =   z * Math.cos(angle) - x * Math.sin(angle);
          x = newx;
          z = newz;
    }

    //*************
    public void setRotatey (double angle) {
          //Rotates point around x-axis
          double newy =   y * Math.cos(angle) + z * Math.sin(angle);
          double newz =   z * Math.cos(angle) - y * Math.sin(angle);
          y = newy;
          z = newz;
    }

    //*************
    public void setRotatez (double angle) {
          //Rotates point around x-axis
          double newx =   x * Math.cos(angle) + y * Math.sin(angle);
          double newy =   y * Math.cos(angle) - x * Math.sin(angle);
          x = newx;
          y = newy;
     }

    //*************
    public void setScale(double xs, double ys, double zs){
          x *= xs;
          y *= ys;
          z *= zs;
    }

    //*************
    public void setMove(double xoff, double yoff, double zoff){
          x += xoff;
          y += yoff;
          z += zoff;
    }

//*************
   public MyPoint setAxonometric(){

      MyPoint p = new MyPoint(0., 0., 0.);
      p.x = x;
      p.y = y;

      return p;

   }

//*************
   public MyPoint setPerspective(){

      MyPoint p = new MyPoint(0., 0., 0.);
      double t = 1.0/(1.0-((double)z/512.)); //Perspective projection
      p.x = x * t;
      p.y = y * t;

      return p;

   }



}

