

import java.awt.*;


public class MyFace  {

	int numPoints;
	MyPoint[] points;
	Color color;

	//********************
 	public MyFace(MyPoint[] inPoints){

      numPoints = inPoints.length;
      points  = new MyPoint[numPoints];

      for(int i=0; i<numPoints; i++)
          points[i] = new MyPoint(inPoints[i].x, inPoints[i].y, inPoints[i].z);

      color = new Color(255, 0, 0);

	}


	//********************
	public void draw(Graphics g){

		Polygon poly = new Polygon();
		for(int i=0; i<numPoints; i++){
			MyPoint p = points[i].setPerspective();
		    poly.addPoint((int)p.x+100, (int)p.y+100);
		}

        g.setColor(color);
		g.fillPolygon(poly);
		g.setColor(Color.black);
		g.drawPolygon(poly);


	}


	//********************
	public void move(double xoff, double yoff, double zoff){

		for(int i=0; i<numPoints; i++)
			points[i].move(xoff, yoff, zoff);

	}


	//*******************
	public void rotatex(double angle){

		for(int i=0; i<numPoints; i++)
			points[i].rotatex(angle);


	}

		//*******************
		public void rotatey(double angle){

			for(int i=0; i<numPoints; i++)
				points[i].rotatey(angle);


	}

		//*******************
		public void rotatez(double angle){

			for(int i=0; i<numPoints; i++)
				points[i].rotatez(angle);


	}


}