
import java.awt.*;
import java.applet.*;

public class MySpace extends Applet{

	int xp, yp;
	MyPoint[] points;

/**
 * A simple program that handles 3D projections.
 *
 * @author DEVELOPER
 * @since 1.0 (1/15/01)
 ************************************/
	public void init(){

         points = new MyPoint[8];

         points[0] = new MyPoint(0.  , 0.  , 0.  );
         points[1] = new MyPoint(100., 0.  , 0.  );
         points[2] = new MyPoint(100., 100., 0.  );
         points[3] = new MyPoint(0.  , 100., 0.  );
         points[4] = new MyPoint(0.  , 0.  , 100.);
         points[5] = new MyPoint(100., 0.  , 100.);
         points[6] = new MyPoint(100., 100., 100.);
         points[7] = new MyPoint(0.  , 100., 100.);

         for(int i=0; i<8; i++)
             points[i].move(-50., -50., -50.);

         repaint();
	}


	//*******************
	public void paint(Graphics g){


        for(int i=0; i<8; i++){
			MyPoint p = new MyPoint(0.,0.,0.);
			p = points[i].setPerspective();
			int xpos = (int)p.x + 300;
			int ypos = (int)p.y + 300;
			g.fillOval(xpos, ypos, 3, 3);
			//g.drawString(".", xpos, ypos);
		}

	}


	//*********************
		public boolean mouseDown(Event e, int x, int y){

			xp = x;
			yp = y;

			return true;
		}



	//*******************
	public boolean mouseDrag(Event e, int x, int y){

		int xoff = x - xp;
		int yoff = y - yp;

		for(int i=0; i<8; i++){
			points[i].rotatey(xoff * Math.PI/180.);
			points[i].rotatex(yoff * Math.PI/180.);
		}

		repaint();

		xp = x;
		yp = y;

		return true;
	}



}