
import java.awt.*;
import java.applet.*;

public class MySpace extends Applet{

	int xp, yp;
	MyPoint[] points;

/**
 * A simple program that handles 3D projections.
 *
 * @author DEVELOPER
 * @since 1.0 (1/15/01)
 ************************************/
	public void init(){

         points = new MyPoint[8];

         points[0] = new MyPoint(0.  , 0.  , 0.  );
         points[1] = new MyPoint(100., 0.  , 0.  );
         points[2] = new MyPoint(100., 100., 0.  );
         points[3] = new MyPoint(0.  , 100., 0.  );
         points[4] = new MyPoint(0.  , 0.  , 100.);
         points[5] = new MyPoint(100., 0.  , 100.);
         points[6] = new MyPoint(100., 100., 100.);
         points[7] = new MyPoint(0.  , 100., 100.);

         for(int i=0; i<8; i++)
             points[i].move(-50., -50., -50.);

         repaint();
	}


	//*******************
	public void paint(Graphics g){

     for(int j=0; j<8; j++)
        for(int i=0; i<8; i++){
			MyPoint p1 = new MyPoint(0.,0.,0.);
			MyPoint p2 = new MyPoint(0.,0.,0.);
			p1 = points[i].setPerspective();
			int xfrom = (int)p1.x + 300;
			int yfrom = (int)p1.y + 300;
			p2 = points[j].setPerspective();
			int xto = (int)p2.x + 300;
			int yto = (int)p2.y + 300;
			g.drawLine(xfrom, yfrom, xto, yto);
		}

	}


	//*********************
		public boolean mouseDown(Event e, int x, int y){

			xp = x;
			yp = y;

			return true;
		}



	//*******************
	public boolean mouseDrag(Event e, int x, int y){

		int xoff = x - xp;
		int yoff = y - yp;

		for(int i=0; i<8; i++){
			points[i].rotatey(xoff * Math.PI/180.);
			points[i].rotatex(yoff * Math.PI/180.);
		}

		repaint();

		xp = x;
		yp = y;

		return true;
	}



}