
/**
 * A 3D point.
 *
 * @author DEVELOPER
 * @since 1.0 (1/15/01)
 ************************************/
public class MyPoint{

	double x;
	double y;
	double z;


	//*************CCCC*******
	public MyPoint(double xinput, double yinput, double zinput){

		x = xinput;
		y = yinput;
		z = zinput;

	}

	//**********************
	public void move(double xoff, double yoff, double zoff){

		x = x + xoff;
		y = y + yoff;
		z = z + zoff;
	}


	//*********************
	public void scale(double xs, double ys, double zs){

			x = x * xs;
			y = y * ys;
			z = z * zs;
	}


	//**********************
	public void rotatez(double angle  ){
		double tempx = x * Math.cos(angle) + y * Math.sin(angle);
		double tempy = y * Math.cos(angle) - x * Math.sin(angle);
        x = tempx;
        y = tempy;
	}

	//**********************
	public void rotatex(double angle  ){
			double tempy = y * Math.cos(angle) + z * Math.sin(angle);
			double tempz = z * Math.cos(angle) - y * Math.sin(angle);
	    y = tempy;
	    z = tempz;
		}


//**********************
	public void rotatey(double angle  ){
		double tempx = x * Math.cos(angle) + z * Math.sin(angle);
		double tempz = z * Math.cos(angle) - x * Math.sin(angle);
        x = tempx;
        z = tempz;
	}


//*************
   public MyPoint setPerspective(){

      MyPoint p = new MyPoint(0., 0., 0.);
      double t = 1.0/(1.0-((double)z/512.)); //Perspective projection
      p.x = x * t;
      p.y = y * t;

      return p;

   }

   //*************
      public MyPoint setAxonometric(){

         MyPoint p = new MyPoint(0., 0., 0.);
         p.x = x;
         p.y = y;

         return p;

   }





}