
import java.awt.*;
import java.awt.image.*;
import java.applet.*;
import javax.swing.*;


public class MyImageCloud extends Applet{

	int xp, yp;
	MyPoint[] points;
	Image offImage;
	Graphics offGraphics;

	Image picture;
	BufferedImage bpicture;
	Graphics2D big;

/**
 * DESCRIPTION
 *
 * @author DEVELOPER
 * @since 1.0 (1/15/01)
 ************************************/
	public void init(){

		 offImage = createImage(800, 600);
		 offGraphics = offImage.getGraphics();

		 picture = getImage(getDocumentBase(), "face.jpg");

		 try{
			 MediaTracker tracker = new MediaTracker(this);
			 tracker.addImage(picture, 0);
			 tracker.waitForID(0);
		 }
		 catch(Exception e){ }

		 int iw = picture.getWidth(this);
		 int ih = picture.getHeight(this);

		 bpicture = new BufferedImage(iw, ih, BufferedImage.TYPE_INT_RGB);
		 big = bpicture.createGraphics();
		 big.drawImage(picture, 0, 0, this);
		 ColorModel cm = ColorModel.getRGBdefault();


		 points = new MyPoint[iw*ih];

		 for(int i=0; i<iw; i++)
			for(int j=0; j<ih; j++){

				int c3 = bpicture.getRGB(i,j);

				points[i*ih+j] = new MyPoint((double) i, (double) j, (double) cm.getBlue(c3)/5);
				points[i*ih+j].setColor(new Color(cm.getRed(c3), cm.getGreen(c3), cm.getBlue(c3)));
			    }


         for(int i=0; i<points.length; i++)
             points[i].move(-100., -100., -100.);

         repaint();
	}


	//*******************
	public void paint(Graphics g){


      offGraphics.setColor(Color.white);
	  offGraphics.fillRect(0,0,800, 600);
      offGraphics.setColor(Color.black);

		for(int i=0; i<points.length; i++){
			MyPoint p = new MyPoint(0.,0.,0.);
			p = points[i].setPerspective(1024.);
			//p = points[i].setAxonometric();
			int xpos = (int)p.x + 300;
			int ypos = (int)p.y + 100;
			offGraphics.setColor(points[i].color);
			offGraphics.drawRect(xpos, ypos, 1, 1);
		}

		offGraphics.drawImage(picture, 0, 0, this);

		g.drawImage(offImage, 0, 0, this);


	}


	//*********************
		public boolean mouseDown(Event e, int x, int y){

			xp = x;
			yp = y;

			return true;
		}



	//*******************
	public boolean mouseDrag(Event e, int x, int y){

		int xoff = x - xp;
		int yoff = y - yp;

		for(int i=0; i<points.length; i++){
			points[i].rotatey(xoff * Math.PI/180.);
			points[i].rotatex(yoff * Math.PI/180.);
		}

		repaint();

		xp = x;
		yp = y;

		return true;
	}



}