
import java.awt.*;
import java.applet.*;

import java.net.*;
import java.io.*;


public class MyServer extends Applet implements Runnable{

   Thread myThread;  //the receiving thread

   int xrect=100, yrect=100; // the initial position

   ServerSocket server;
   Socket connection;
   DataInputStream  input;  // the input stream

//*******************
    public void init(){
        runServer();
    }

//*********************************
    public void start() {
        if(myThread == null) {
            myThread = new Thread(this);
            myThread.start();
        }
    }

//*********************************
    public void stop() {
        if(myThread != null) {
            myThread.stop();
            myThread = null;
        }
    }

//*********************************
   public void run() {
    while(myThread != null){
      try{
        receiveData();
        myThread.sleep(20);
        }
       catch(InterruptedException ioe) {
        stop();
       }
    }
   }


//*******************
    public void paint(Graphics g){
       g.fillRect(xrect, yrect, 5, 5);
    }

//*******************
    public void update(Graphics g){
       paint(g);
    }

//******************
    public boolean mouseDrag(Event evt, int xmouse, int ymouse){

        xrect = xmouse;
        yrect = ymouse;
        repaint();

        return true;
    }

//************************
   public void runServer(){

    try{

		server = new ServerSocket(  5000);
		System.out.println("Waiting for connection...");
		connection = server.accept();

		input = new DataInputStream(connection.getInputStream() );
		System.out.println("Connection established with client:" +
							 connection.getInetAddress().getHostName());
        }
	catch(IOException ioe){
			System.out.println("No connection");
        }

   }

	//*****************
	public void receiveData(){

		try{
			xrect = input.readInt();
			yrect = input.readInt();
			System.out.println("Server has received " + xrect + " " + yrect);
			repaint();
		}
		catch(IOException ioe){
			System.out.println("No connection");
		}

	}

}