
import java.applet.*;
import java.awt.*;
import java.awt.image.*;

public class MyImage extends Applet {

	int width;     // the width of the image
	int height;    // the height of the image
    int[] pixels;  // an array to hold the pixels
    Image myImage; // the image to process

    //********************
    public void init(){

	 myImage = getImage(getCodeBase(), "royce.jpg");
	 getThePixels(myImage);
     invert();
     average();
     myImage = showImage();

	}

    /**
	*  Grab the pixels in order to process them
	*************************************/
    public void getThePixels(Image picture)
    {

        waitToOpenImage(picture);

        width=picture.getWidth(this);
        height=picture.getHeight(this);
        pixels=new int[width*height];
        PixelGrabber pg=new PixelGrabber(picture,0,0,width,height,pixels,0,width);

        try
        {
            pg.grabPixels();
        } catch (InterruptedException e){
            System.out.println("Cannot grab Pixels");
        }

    }

	/**
	*  Make sure the image is loaded before you process it
	*************************************/
	 void waitToOpenImage(Image picture)
	{
		MediaTracker tracker=new MediaTracker(this);
		tracker.addImage(picture,0);
		try
		{
			tracker.waitForID(0);
		} catch (InterruptedException e){
			System.out.println("Cannot wait for picture");
		}
	}


	/**
	*  Inverts the value of all pixels
	*************************************/
	void invert()
	{
		for(int index=0;index<width*height;index++)
		pixels[index]=pixels[index]^0xffffff;
	}

    /**
	*  Assigns the average of RGB to a pixel
	*  (essentially it converts to grayscale)
	*************************************/
		void average()
		{
		    for(int index=0;index<width*height;index++)
		    {
		        int c=pixels[index];
		        int r=(c&0xff0000)>>16;
		        int g=(c&0xff00)>>8;
		        int b=(c&0xff);

		        int altered= (r + g + b) /3;

		        pixels[index] = (c&0xff000000)+(altered<<16)+(altered<<8)+ altered;
		    }
    }

    /**
	*  Load a new image with the changes
	*************************************/
	public Image showImage()
	{
		return createImage(new MemoryImageSource(width,height,pixels,0,width));
	}


    //********************
    public void paint(Graphics g){

    g.drawImage(myImage, 0, 0, this);
    System.out.println("paint");

	}


}

