
import java.awt.*;

public class MyShape {

    MySegment[] segs;  // members of class
    int numSegments;
    Color color = Color.blue;
    boolean isSelected = false;


    //********** Constructor
    public MyShape(int numInputSegments, MySegment[] inputSegments){

        numSegments = numInputSegments;
        segs = new MySegment[numSegments];

        for(int i=0; i<numSegments; i++)
           segs[i] = inputSegments[i];
    }


  //*************** An alternative constructor
  //*************** Creates
   public MyShape(int numSides, double radius, double xoff, double yoff){

    numSegments = numSides;
    segs = new MySegment[numSegments];

   //divide the full circle in nsides sections
   double angle = 2 * Math.PI / numSegments;

    // create two points to store the segment points
    MyPoint p = new MyPoint(0.,0.);
    MyPoint pnext = new MyPoint(0.,0.);

    // loop to assign values to the points
    for(int i =0; i<numSegments; i++){
        p.x     = xoff + radius * Math.sin(angle*i);
        p.y     = yoff + radius * Math.cos(angle*i);
        pnext.x = xoff + radius * Math.sin(angle*(i+1));
        pnext.y = yoff + radius * Math.cos(angle*(i+1));
        segs[i] = new MySegment(p, pnext);
    }

   }


    //********** Move
    public void move(double xoff, double yoff){

        for(int i=0; i<numSegments; i++)
           segs[i].move(xoff, yoff);
    }

    //*********** draw
    public void draw(Graphics g){

        for(int i=0; i<numSegments; i++)
           segs[i].draw(g);

    }


    //********** random
    public void randomize(double range){

        for(int i=0; i<numSegments; i++)
            segs[i].randomize(range);

    }


    //************
    public void print(){

      for(int i=0; i<numSegments; i++)
        segs[i].print();

    }

    //********** scale
    public void scale(double xs, double ys, MyPoint ref){

       for(int i=0; i<numSegments; i++)
          segs[i].scale(xs, ys, ref);

    }

    //********** rotate
    public void rotate(double angle, MyPoint ref){

       for(int i=0; i<numSegments; i++)
        segs[i].rotate(angle, ref);

    }

      //******** Return the center
     public MyPoint centroid(){

        MyPoint c = new MyPoint(0., 0.);

        for(int i=0; i<numSegments; i++){
            c.x += (segs[i].centroid()).x;
            c.y += (segs[i].centroid()).y;
        }

        c.x /= numSegments;
        c.y /= numSegments;

        return c;

     }


      //******** Select
     public boolean select(double xpick, double ypick, double tolerance){
         for(int i=0; i<numSegments; i++){
             if(segs[i].select(xpick, ypick, tolerance)==true){
                isSelected = true;
                for(int j=0; j<numSegments; j++)   //if one segment is selected the
                    segs[j].isSelected = true;     //all the segments should be selected
                return true;
             }
             else {
                isSelected = false;
             }
         }
     return false;
     }



}