
import java.awt.*;

public class MySegment {

    // members of class
    MyPoint start = new MyPoint(0., 0.);    // start point
    MyPoint end   = new MyPoint(0., 0.);    // end point
    Color color = Color.blue;               // default color
    boolean isSelected = false;             // is this shape selected?


    //********** Constructor
    public MySegment(MyPoint p1, MyPoint p2){

        start.x = p1.x;
        start.y = p1.y;
        end.x   = p2.x;
        end.y   = p2.y;
    }

    //********** Move
    public void move(double xoff, double yoff){

        start.move(xoff, yoff);
        end.move(xoff, yoff);
    }

    //*********** draw
    public void draw(Graphics g){

        if(isSelected)
            g.setColor(Color.red);
        else
            g.setColor(color);
        g.drawLine((int)start.x, (int)start.y, (int)end.x, (int)end.y);

    }

    //************ random
    public void randomize(double range){

     start.randomize(range);
     end.randomize(range);

    }


    //************
    public void print(){

        start.print();
        end.print();

    }

    //********** scale
    public void scale(double xs, double ys, MyPoint ref){

       start.scale(xs, ys, ref);
        end.scale(xs, ys, ref);

    }

    //********** rotate
    public void rotate(double angle, MyPoint ref){

       start.rotate(angle, ref);
        end.rotate(angle, ref);

    }

     //******** Method
     public MyPoint centroid(){

        MyPoint c = new MyPoint(0., 0.);

        c.x = (start.x + end.x)/2;
        c.y = (start.y + end.y)/2;

        return c;


     }

     //******** Method
     public boolean select(double xpick, double ypick, double tolerance){
             if(start.select(xpick, ypick, tolerance)==true  ||
                  end.select(xpick, ypick, tolerance)==true)    {
                isSelected = true;
                return true;
             }
             else {
                isSelected = false;
             }
     return false;
     }






}