import java.awt.*;

/**
 * Implements the behavior of a geometrical point
 * @author Kostas Terzidis
 * @version 1.0
 *
 ** Class *****************************/
public class MyPoint {

    double x, y;  // members of class
    Color color = Color.blue;
    boolean isSelected = false;


    /**
     * Creates a point given two coordinates
     * @param xin The x coordinate.
     * @param yin The y coordinate.
     *****************************************/
    public MyPoint(double xin, double yin){

        x = xin;
        y = yin;

    }


    /**
     * Moves a point by an offset
     * @param xoff The x offset.
     * @param yoff The y offset.
     *******************************************/
    public void move(double xoff, double yoff){
        x = x + xoff;
        y = y + yoff;
    }


    /**
     * The purpose of this method is to ...
     * @param param1 The value to test for ...
     * @return A boolean value that tells whether or not ...
     *****************************************************/
    public void randomize(double range){

        x += range * Math.random();
        y += range * Math.random();

    }


    //********** Print
    public void print(){

        System.out.println("x = " + x  + " y = " + y);
    }


    //********** scale
    public void scale(double xs, double ys, MyPoint ref){

       x = (x-ref.x) * xs + ref.x;
       y = (y-ref.y) * ys + ref.y;

    }

    //********** Rotate around point ref
    public void rotate (double angle, MyPoint ref) {
        double cosa, sina;
        cosa = Math.cos(Math.PI/180*angle);
        sina = Math.sin(Math.PI/180*angle);
             double newx = (x-ref.x) * cosa - (y-ref.y) * sina + ref.x;
             double newy = (y-ref.y) * cosa + (x-ref.x) * sina + ref.y;
              x = newx;
              y = newy;
         }

    //*************
    public boolean select(double xpick, double ypick, double tolerance){

        if(Math.abs(x - xpick) < tolerance  && Math.abs(y - ypick) < tolerance ) {
            isSelected = true;
            return true;
        }
        else {
                isSelected = false;
             }
        return false;

    }



}