
import java.awt.*;

public class MyGroup {

    // members of class
    MyShape[] shapes;           // array of shapes
    int numShapes;              //number of shapes
    Color color;                //default color
    boolean isSelected = false; //is this group selected?

    //********** Constructor
    public MyGroup(int numInputShapes, MyShape[] inputShapes){

        numShapes = numInputShapes;
        shapes = new MyShape[numShapes];

        for(int i=0; i<numShapes; i++)
           shapes[i] = inputShapes[i];
    }

    //********** Move
    public void move(double xoff, double yoff){

        for(int i=0; i<numShapes; i++)
           shapes[i].move(xoff, yoff);
    }

    //*********** draw
    public void draw(Graphics g){

        for(int i=0; i<numShapes; i++)
           shapes[i].draw(g);

    }

    //********** scale
    public void scale(double xs, double ys, MyPoint ref){

       for(int i=0; i<numShapes; i++)
          shapes[i].scale(xs, ys, ref);

    }

    //********** rotate
    public void rotate(double angle, MyPoint ref){

       for(int i=0; i<numShapes; i++)
        shapes[i].rotate(angle, ref);

    }

    //********** randomize
    public void randomize(double range){

       for(int i=0; i<numShapes; i++)
        shapes[i].randomize(range);

    }


     //******** Select
     public boolean select(double xpick, double ypick, double tolerance){
         for(int i=0; i<numShapes; i++)
             if(shapes[i].select(xpick, ypick, tolerance)==true){
                isSelected = true;
                return true;
             }
             else{
                isSelected = false;
             }
     return false;
     }



}