import java.io.*;
import java.util.*;

public class MyFile {

    public MyFile(){
        ;
    }

    //**************************************
    public void openDXF(String inFilename){



    }


    //**************************************
    public void saveDXF(String outFilename){


    }




//*********************************************************
void writeNativeFile(MyGroup group, String fileOut) throws IOException  {

   System.out.println("Writing fileOut = " + fileOut + "...");
   FileOutputStream file = new FileOutputStream(fileOut);   // file creation
   DataOutputStream stream = new DataOutputStream(file);      // data stream to write

    try {
         stream.writeUTF("Kostas Format");  // file identifier
         stream.writeInt(group.numShapes);
         for(int k=0; k<group.numShapes; k++){
            stream.writeInt(group.shapes[k].numSegments);
            for(int j=0; j<group.shapes[k].numSegments; j++){
                stream.writeDouble(group.shapes[k].segs[j].start.x);
                stream.writeDouble(group.shapes[k].segs[j].start.y);
                stream.writeDouble(group.shapes[k].segs[j].end.x);
                stream.writeDouble(group.shapes[k].segs[j].end.y);
                }
         }

        file.close();
    }
    catch(IOException e) {
        System.out.println("File problems!!");
        System.exit(1);
    }

}


     //*********************************************************
     public MyGroup readNativeFile(String fileIn) throws IOException
      {

      System.out.println("Reading fileOut = " + fileIn);
      FileInputStream is = new FileInputStream(fileIn);
      DataInputStream file = new DataInputStream(is);


         try{
             //*** Check to see if its of Kosta's native file format
             String name = file.readUTF();
             if(name.equals("Kostas Format")==false){
                System.out.println("File format not recognized: " + name);
                return null;
                }
             // loop to read the data
             MyGroup group;
             int numShapes = file.readInt();
             MyShape shapes[] = new MyShape[numShapes];
             for(int k=0; k<numShapes; k++){
                int numSegments = file.readInt();
                MySegment segs[] = new MySegment[numSegments];
                for(int j=0; j<numSegments; j++){
                    double x1 = file.readDouble();
                    double y1 = file.readDouble();
                    MyPoint start = new MyPoint(x1, y1);
                    double x2 = file.readDouble();
                    double y2 = file.readDouble();
                    MyPoint end = new MyPoint(x2, y2);
                    segs[j] = new MySegment(start, end);
                }
                shapes[k] = new MyShape(numSegments, segs);
             }
             group = new MyGroup(numShapes, shapes);

             //**** Finish
             file.close();
             return group;

        }
        catch(IOException e) {
            System.err.println("File problems!!" );
            System.exit(1);
            }

        return null;
     }




/*********************************************************/
void writeDXFFile(MyGroup group, String filename) throws IOException
     {

       System.out.println("Writing file " + filename + "...");
       FileOutputStream file = new FileOutputStream(filename);
       DataOutputStream stream = new DataOutputStream(file);

        try {
             stream.writeBytes("999\r\n");
             stream.writeBytes("Kostas\r\n");
             stream.writeBytes("  0\r\n");
             stream.writeBytes("SECTION\r\n");
             stream.writeBytes("  2\r\n");
             stream.writeBytes("ENTITIES\r\n");
             stream.writeBytes("  0\r\n");

              // for shapes
             for(int k=0; k<group.numShapes; k++){
                 stream.writeBytes("POLYLINE\r\n");
                 stream.writeBytes("  8\r\n");      // layer
                 stream.writeBytes("layer_1\r\n");
                 stream.writeBytes(" 66\r\n");
                 stream.writeBytes("    1\r\n");
                 stream.writeBytes(" 70\r\n");
                 stream.writeBytes("    9\r\n");
                 stream.writeBytes(" 62\r\n");      // Color
                 stream.writeBytes("   183\r\n");
                 stream.writeBytes("  0\r\n");

                 // for points
                 for(int j=0; j<group.shapes[k].numSegments; j++){
                    stream.writeBytes("VERTEX\r\n");
                    stream.writeBytes("10\r\n");   // x
                    stream.writeBytes(Double.toString(group.shapes[k].segs[j].start.x) +"\r\n");
                    stream.writeBytes(" 20\r\n");  // y
                    stream.writeBytes(Double.toString(group.shapes[k].segs[j].start.y)+"\r\n");
                    stream.writeBytes(" 30\r\n");  // z
                    stream.writeBytes(Double.toString(0.0)+"\r\n");
                    stream.writeBytes(" 70\r\n");
                    stream.writeBytes("   32\r\n");
                    stream.writeBytes("  0\r\n");
                  }
               stream.writeBytes("SEQEND\r\n");
               stream.writeBytes("  0\r\n");
             }

           stream.writeBytes("ENDSEC\r\n");
           stream.writeBytes("  0\r\n");
           stream.writeBytes("EOF\r\n");

           //*** Finish
           stream.flush();
           stream.close();

           }
        catch(IOException e) {
            System.err.println("Problems writing file!!" );
           }

     }


/**********************************************************/
 public MyGroup readDXFFile(String fileIn) throws IOException
     {

     Vector vshapes = new Vector();

     System.out.println("Reading DXF file " + fileIn + "...");
     FileInputStream is = new FileInputStream(fileIn);
     DataInputStream file = new DataInputStream(is);

	 StreamTokenizer st = new StreamTokenizer(is);
	 st.eolIsSignificant(true);
     st.wordChars(' ','_');

    boolean exit = false;  //flag to exit

	while (true) {
	    if(exit) break;
        st.nextToken();
	    switch (st.ttype) {
		case StreamTokenizer.TT_EOF:
		 exit = true;
		break;
		case StreamTokenizer.TT_WORD:
		    if ("POLYLINE".equals(st.sval)){
		        MyShape shape = processPOLYLINE(st);
		        vshapes.addElement(shape);
		    }
        break;
        default:
		break;
	    }  /* switch */
	}  /* while */


    System.out.println("Finished ");
    int numShapes = vshapes.size();
    MyShape[] shapes = new MyShape[numShapes];
    for(int i=0; i<numShapes; i++)
         shapes[i] = (MyShape)vshapes.elementAt(i);
    MyGroup group = new MyGroup(numShapes, shapes);

	file.close();
    return group;
    }


/********************************************************************/
private MyShape processPOLYLINE(StreamTokenizer st) throws IOException {

    double x=0.,y=0.;
    double tempx=0., tempy=0.;
    Vector vpoints = new Vector();
    boolean first = true;
    boolean vertex_found = false;

    first = true;
    vertex_found=false;
    while(true)
        {
        st.nextToken();
        if ("VERTEX".equals(st.sval)){
            vertex_found=true;
       }
        if ("AcDbFaceRecord".equals(st.sval)){  // this is a bug-fix for formZ
            vertex_found=false;
       }
        if ("SEQEND".equals(st.sval)){
            vpoints.addElement(new MyPoint(tempx, tempy));  // add the first point
            first = false;
            vertex_found = false;
            break;
       }
       if (st.nval == 10 && vertex_found==true) {
           if(st.nextToken() == StreamTokenizer.TT_EOL)
           if (st.nextToken() == StreamTokenizer.TT_NUMBER)
                 x = st.nval;
           if(st.nextToken() == StreamTokenizer.TT_EOL)
           if (st.nextToken() == StreamTokenizer.TT_NUMBER)
           if(st.nextToken() == StreamTokenizer.TT_EOL)
           if (st.nextToken() == StreamTokenizer.TT_NUMBER)
                 y = st.nval;

           // to keep the first point to add later as the end point for the segment
           if(first == true && vertex_found==true){
              tempx = x;
              tempy = y;
              first = false;
           }
           vpoints.addElement(new MyPoint(x, y));

      }  /* if (==20)*/

   }  /* while */


    // create a shape out of the vector
    int numSegments = vpoints.size()-1;
    MySegment[] segs = new MySegment[numSegments];
    for(int i=0; i<numSegments; i++)
    segs[i] = new MySegment((MyPoint)vpoints.elementAt(i),
                            (MyPoint)vpoints.elementAt(i+1));
    MyShape shape = new MyShape(numSegments, segs);
    //shape.print();
    return shape;

}

}