
import java.awt.*;

public class MyShape {

    MySegment[] segs;  // members of class
    int numSegments;

    //********** Constructor
    public MyShape(int numInputSegments, MySegment[] inputSegments){

        numSegments = numInputSegments;
        segs = new MySegment[numSegments];

        for(int i=0; i<numSegments; i++)
           segs[i] = inputSegments[i];
    }


    //********** Move
    public void move(double xoff, double yoff){

        for(int i=0; i<numSegments; i++)
           segs[i].move(xoff, yoff);
    }

    //********** Rotate
    public void rotate (double angle, MyPoint ref) {
        for(int i=0; i<numSegments; i++)
            segs[i].rotate(angle, ref);
     }


    //********** Scale
    public void scale(double xs, double ys, MyPoint ref){
        for(int i=0; i<numSegments; i++)
           segs[i].scale(xs, ys, ref);
    }


    //*********** draw
    public void draw(Graphics g){

        for(int i=0; i<numSegments; i++)
           segs[i].draw(g);


    }



}